;/**
;  ******************************************************************************
;  * @file    startup_MDR1986BE4.S
;  * @author  Milandr Application Team
;  * @version V2.0
;  * @date    10/08/2021
;  * @brief   CMSIS core device startup file for MDR1986BE4.
;  ******************************************************************************
;  * <br><br>
;  *
;  * THE PRESENT FIRMWARE IS FOR GUIDANCE ONLY. IT AIMS AT PROVIDING CUSTOMERS
;  * WITH CODING INFORMATION REGARDING MILANDR'S PRODUCTS IN ORDER TO FACILITATE
;  * THE USE AND SAVE TIME. MILANDR SHALL NOT BE HELD LIABLE FOR ANY
;  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES RESULTING
;  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR A USE MADE BY CUSTOMERS OF THE
;  * CODING INFORMATION CONTAINED HEREIN IN THEIR PRODUCTS.
;  *
;  * <h2><center>&copy; COPYRIGHT 2024 Milandr</center></h2>
;  ******************************************************************************
;  */

;//--------- <<< Use Configuration Wizard in Context Menu >>> ------------------

;<h> Stack Configuration
;  <o> Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
;</h>

Stack_Size      EQU     0x00000400

                AREA    STACK, NOINIT, READWRITE, ALIGN=3
__stack_limit
Stack_Mem       SPACE   Stack_Size
__initial_sp


;<h> Heap Configuration
;  <o>  Heap Size (in Bytes) <0x0-0xFFFFFFFF:8>
;</h>

Heap_Size       EQU     0x00001000

                AREA    HEAP, NOINIT, READWRITE, ALIGN=3
__heap_base
Heap_Mem        SPACE   Heap_Size
__heap_limit

                PRESERVE8
                THUMB


; Vector Table Mapped to Address 0 at Reset
                AREA    RESET, DATA, READONLY
                EXPORT  __Vectors
                EXPORT  __Vectors_End
                EXPORT  __Vectors_Size

; Attention for NonMaskableInt_Handler:
; Called by software only (bit [31] of the ICSR register). Used for mission critical applications
__Vectors       DCD     __initial_sp                ;     Top of Stack
                DCD     Reset_Handler               ;     Reset Handler
                DCD     NonMaskableInt_Handler      ; -14 NMI Handler
                DCD     HardFault_Handler           ; -13 Hard Fault Handler
                DCD     0                           ;     Reserved
                DCD     0                           ;     Reserved
                DCD     0                           ;     Reserved
                DCD     0                           ;     Reserved
                DCD     0                           ;     Reserved
                DCD     0                           ;     Reserved
                DCD     0                           ;     Reserved
                DCD     SVC_Handler                 ;  -5 SVCall Handler
                DCD     0                           ;     Reserved
                DCD     0                           ;     Reserved
                DCD     PendSV_Handler              ;  -2 PendSV Handler
                DCD     SysTick_Handler             ;  -1 SysTick Handler

                ; External Interrupts
                DCD     DMA_IRQHandler              ;   0 DMA Handler
                DCD     UART1_IRQHandler            ;   1 UART1 Handler
                DCD     UART2_IRQHandler            ;   2 UART2 Handler
                DCD     SSP1_IRQHandler             ;   3 SSP1 Handler
                DCD     POWER_IRQHandler            ;   4 POWER Handler
                DCD     WWDG_IRQHandler             ;   5 WWDG Handler
                DCD     TIMER1_IRQHandler           ;   6 Timer1 Handler
                DCD     TIMER2_IRQHandler           ;   7 Timer2 Handler
                DCD     ADC_IRQHandler              ;   8 ADC Handler
                DCD     COMPARATOR_IRQHandler       ;   9 COMPARATOR Handler
                DCD     BACKUP_IRQHandler           ;  10 BACKUP Handler
                DCD     EXT_INT0_IRQHandler         ;  11 EXT_INT0 Handler
                DCD     EXT_INT1_IRQHandler         ;  12 EXT_INT1 Handler
                DCD     EXT_INT2_IRQHandler         ;  13 EXT_INT2 Handler
                DCD     ADCIU_CH1_IRQHandler        ;  14 ADCIU_CH1 Handler
                DCD     ADCIU_CH2_IRQHandler        ;  15 ADCIU_CH2 Handler
                DCD     ADCIU_CH3_IRQHandler        ;  16 ADCIU_CH3 Handler
                DCD     ADCIU_CH4_IRQHandler        ;  17 ADCIU_CH4 Handler
                DCD     ADCIU_CH5_IRQHandler        ;  18 ADCIU_CH5 Handler
                DCD     ADCIU_CH6_IRQHandler        ;  19 ADCIU_CH6 Handler
                DCD     ADCIU_CH7_IRQHandler        ;  20 ADCIU_CH7 Handler
                DCD     ADCIU_CH8_IRQHandler        ;  21 ADCIU_CH8 Handler
                DCD     ADCIU_IRQHandler            ;  22 ADCIU Handler
__Vectors_End

__Vectors_Size  EQU  __Vectors_End - __Vectors

                AREA    |.text|, CODE, READONLY

; Reset handler
Reset_Handler    PROC
                 EXPORT  Reset_Handler              [WEAK]
        IMPORT  SystemInit
        IMPORT  __main
                 LDR     R0, =SystemInit
                 BLX     R0
                 LDR     R0, =__main
                 BX      R0
                 ENDP


; Dummy Exception Handlers (infinite loops which can be modified)

NonMaskableInt_Handler  PROC
                EXPORT  NonMaskableInt_Handler      [WEAK]
                B       .
                ENDP

HardFault_Handler       PROC
                EXPORT  HardFault_Handler           [WEAK]
                B       .
                ENDP

SVC_Handler     PROC
                EXPORT  SVC_Handler                 [WEAK]
                B       .
                ENDP

PendSV_Handler  PROC
                EXPORT  PendSV_Handler              [WEAK]
                B       .
                ENDP

SysTick_Handler PROC
                EXPORT  SysTick_Handler             [WEAK]
                B       .
                ENDP


; External Interrupts

DMA_IRQHandler  PROC
                EXPORT  DMA_IRQHandler              [WEAK]
                B       .
                ENDP

UART1_IRQHandler        PROC
                EXPORT  UART1_IRQHandler            [WEAK]
                B       .
                ENDP

UART2_IRQHandler        PROC
                EXPORT  UART2_IRQHandler            [WEAK]
                B       .
                ENDP

SSP1_IRQHandler         PROC
                EXPORT  SSP1_IRQHandler             [WEAK]
                B       .
                ENDP

POWER_IRQHandler        PROC
                EXPORT  POWER_IRQHandler            [WEAK]
                B       .
                ENDP

WWDG_IRQHandler         PROC
                EXPORT  WWDG_IRQHandler             [WEAK]
                B       .
                ENDP

TIMER1_IRQHandler       PROC
                EXPORT  TIMER1_IRQHandler           [WEAK]
                B       .
                     ENDP

TIMER2_IRQHandler       PROC
                EXPORT  TIMER2_IRQHandler           [WEAK]
                B       .
                ENDP

ADC_IRQHandler          PROC
                EXPORT  ADC_IRQHandler              [WEAK]
                B       .
                ENDP

COMPARATOR_IRQHandler   PROC
                EXPORT  COMPARATOR_IRQHandler       [WEAK]
                B       .
                ENDP

BACKUP_IRQHandler       PROC
                EXPORT  BACKUP_IRQHandler           [WEAK]
                B       .
                ENDP

EXT_INT0_IRQHandler     PROC
                EXPORT  EXT_INT0_IRQHandler         [WEAK]
                B       .
                ENDP

EXT_INT1_IRQHandler     PROC
                EXPORT  EXT_INT1_IRQHandler         [WEAK]
                B       .
                ENDP

EXT_INT2_IRQHandler     PROC
                EXPORT  EXT_INT2_IRQHandler         [WEAK]
                B       .
                ENDP

ADCIU_CH1_IRQHandler    PROC
                EXPORT  ADCIU_CH1_IRQHandler        [WEAK]
                B       .
                ENDP

ADCIU_CH2_IRQHandler    PROC
                EXPORT  ADCIU_CH2_IRQHandler        [WEAK]
                B       .
                ENDP

ADCIU_CH3_IRQHandler    PROC
                EXPORT  ADCIU_CH3_IRQHandler        [WEAK]
                B       .
                ENDP

ADCIU_CH4_IRQHandler    PROC
                EXPORT  ADCIU_CH4_IRQHandler        [WEAK]
                B       .
                ENDP

ADCIU_CH5_IRQHandler    PROC
                EXPORT  ADCIU_CH5_IRQHandler        [WEAK]
                B       .
                ENDP

ADCIU_CH6_IRQHandler    PROC
                EXPORT  ADCIU_CH6_IRQHandler        [WEAK]
                B       .
                ENDP

ADCIU_CH7_IRQHandler    PROC
                EXPORT  ADCIU_CH7_IRQHandler        [WEAK]
                B       .
                ENDP

ADCIU_CH8_IRQHandler    PROC
                EXPORT  ADCIU_CH8_IRQHandler        [WEAK]
                B       .
                ENDP

ADCIU_IRQHandler        PROC
                EXPORT  ADCIU_IRQHandler            [WEAK]
                B       .
                ENDP

                ALIGN



; User Initial Stack & Heap

                IF      :DEF:__MICROLIB

                EXPORT  __initial_sp
                EXPORT  __stack_limit
                EXPORT  __heap_base
                EXPORT  __heap_limit

                ELSE

                IMPORT  __use_two_region_memory
                EXPORT  __user_initial_stackheap
__user_initial_stackheap

                LDR     R0, = Heap_Mem
                LDR     R1, = (Stack_Mem + Stack_Size)
                LDR     R2, = (Heap_Mem +  Heap_Size)
                LDR     R3, = Stack_Mem
                BX      LR

                ALIGN

                ENDIF


                END


